from typing import Optional

from wikitextprocessor import Wtp
from wiktextract import WiktextractContext, WiktionaryConfig


def get_wiktextract_context(wiktlang: str, wordlang: Optional[str] = None):
    db_path = f"./sqlite-{wiktlang}-all.db"
    config = WiktionaryConfig(
        dump_file_lang_code=wiktlang,
        capture_language_codes=[wordlang] if wordlang else None,
        capture_translations=True,
        capture_pronunciation=True,
        capture_linkages=True,
        capture_compounds=True,
        capture_redirects=True,
        capture_examples=True,
        capture_etymologies=True,
        capture_descendants=True,
        capture_inflections=True,
    )
    config.load_edition_settings()
    wtp = Wtp(db_path=db_path, lang_code=wiktlang)
    wxr = WiktextractContext(wtp, config)

    return wxr
