from wiktextract.page import parse_page

from wiktextract_context import get_wiktextract_context


class Wiktextract:
    def __init__(self, wiktlang: str, wordlang: str):
        self.wiktlang = wiktlang
        self.wordlang = wordlang

        self.wxr = get_wiktextract_context(wiktlang, wordlang)

    def parse_page(self, title: str):
        page = self.wxr.wtp.get_page(title)
        if not page:
            return None
        result = parse_page(self.wxr, title, page.body)

        return result
