import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns

# Definition of the color palette
color_palette = {
    'random': '#333333',  # Black
    'gpt-4.5-preview-2025-02-27': '#7abaff',  # BlueEscape
    'llama3': '#32a68c',  # GreenFuture
    'llama3.3:latest': '#4b9f7d',  # GreenLlama3.3
    'mistral-small': '#ff6941',  # WarmOrange
    'mixtral:8x7b': '#f1a61a',  # YellowMixtral
    'deepseek-r1': '#5862ed',  # InclusiveIndigo
    'deepseek-r1:7b': '#9a7bff',  # PurpleDeepseek-r1:7b
    'qwen3': '#c02942'
}

# Load the data
data = pd.read_csv("../../data/ultimatum/proposer.csv")  # Replace with the correct path to your CSV file

# Specify the order of models for the x-axis
model_order = [
    'gpt-4.5-preview-2025-02-27',
    'llama3', 'llama3.3:latest',  # Place llama3 and llama3.3:latest together
    'mistral-small', 'mixtral:8x7b',  # Bring mistral-small and mixtral:8x7b closer
    'deepseek-r1', 'deepseek-r1:7b',
    'qwen3'
]

# Create the violin plot
plt.figure(figsize=(12, 6))
sns.violinplot(
    data=data,
    x="model",
    y="my_share",
    hue="model",  # Use hue to manage the colors
    palette=color_palette,
    inner="quartile",  # Displays quartiles inside the violin
    density_norm="width",  # Normalizes the width of the violins for comparison
    order=model_order  # Explicitly set the order of the models on the x-axis
)

# Add vertical lines for strategies
strategy_values = {
    'gpt-4.5-preview-2025-02-27': 70,
    'llama3': 50,
    'llama3.3:latest': 60,
    'mistral-small': 50,
    'mixtral:8x7b': 40,
    'deepseek-r1:7b': 60,
    'qwen3': 50
}

for model, value in strategy_values.items():
    plt.axhline(y=value, color=color_palette[model], linestyle="dashed", linewidth=2, label=f"{model} strategy")

# Ajouter les valeurs médianes comme annotations sur le graphique
for model in model_order:
    mediane = data[data['model'] == model]['my_share'].median()
    plt.text(model_order.index(model), mediane, f'{mediane:.1f}', 
             horizontalalignment='center', verticalalignment='bottom')

# Set the y-axis limits between 0 and 100
plt.ylim(0, 100)

# Labels and title
plt.xlabel("Model")
plt.ylabel("Share of money assigned to oneself")
plt.title("Distribution of personal share by model in the ultimatum game")
plt.legend()

# Save and display the plot
plt.savefig("../../figures/ultimatum/proposer_violin.svg", format="svg")