
import asyncio
from proposer import Proposer

class UltimatumExperiment:
    debug = True

    def __init__(self, models: list[str], temperature: float, amount: int, iterations: int, output_file: str):
        self.models = models
        self.temperature = temperature
        self.amount = amount
        self.iterations = iterations
        self.output_file = output_file

        with open(self.output_file, 'w', encoding='utf-8') as f:
            f.write("iteration,model,temperature,amount,my_share,other_share,reasoning\n")

    async def run_experiment(self):
        for model in self.models:
            if self.debug:
                print(f"Running experiment for model: {model}")

            for iteration in range(1, self.iterations + 1):
                game_agent = Proposer(amount=self.amount, model=model, temperature=self.temperature)
                response = await game_agent.run()
                if self.debug:
                    print(response)

                # Utilisation de la notation point pour accéder aux attributs
                my_share = response.my_share
                other_share = response.other_share
                reasoning = response.reasoning.replace('"', '""')

                with open(self.output_file, 'a', encoding='utf-8') as f:
                    f.write(f'{iteration},{model},{self.temperature},{self.amount},{my_share},{other_share},"{reasoning}"\n')


if __name__ == "__main__":
    models = ["qwen3"]
    # # "gpt-4.5-preview-2025-02-27" "llama3", "mistral-small", "deepseek-r1", "qwen3", "mixtral:8x7b", "llama3.3:latest", "deepseek-r1:7b"
    temperature = 0.7
    amount = 100
    iterations = 30
    output_file = '../../data/ultimatum/proposer.csv'

    experiment = UltimatumExperiment(models=models, temperature=temperature, amount=amount, iterations=iterations, output_file=output_file)

    asyncio.run(experiment.run_experiment())
    print(f"Experiment results saved to {output_file}")